#!/bin/bash




fv_exec="/usr/local/FieldView/fv13/fv/bin/fv"
FileFVX="./orgCreateImage.fvx"
SleepTime="10"


#make fgrun

nCount=1
while true; do

	nCount=$((nCount+1))
	echo "nCount : "$nCount

	### FV-UNS convert only latest time
	foamToFieldview9  -latestTime

	### detect latest FV-UNS file name
	LatestUnsFile=`ls -la ./Fieldview/*.uns | head -n1 | awk '{printf($8, "%c")}' `
	echo "Latest FV-UNS:"${LatestUnsFile}

	sed   "s@strFileName@"${LatestUnsFile}"@g" ${FileFVX} > ./tmp.fvx
	sed   "s@numF@"${nCount}"@g" ./tmp.fvx > ./CreateImage.fvx

	### execute FVX batch
	$fv_exec -batch  -fvx ./CreateImage.fvx


	echo `date` "done:"
	sleep ${SleepTime}

done
