!!-----------------------------------------------------------------------
!!--
!!-- Copyright (c) 2009 VINAS
!!-- All rights reserved.
!!--
!!-- This sample FVX script is not supported by VINAS and VINAS provides
!!-- no warranties or assurances about its fitness or merchantability.
!!-- It is provided at no cost and is for demonstration purposes only.
!!--
!!--
!!--                                          Binary2ASCII_FVP.f  
!!--
!!--                                          T.Y.   Fri. June 19, 2009 
!!--
!!----------------------------------------------------------------------
!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      program Binary2ASCII_FVP          ! fvp(binary) -> fvp(ascii)

      parameter(md=100)

      character(len=256)  FileInput     ! input file
      character(len=256)  FileOutput    ! output file

      character(len=4) charTEMP         ! temporary character
!      integer*4 intFV_MAGIC             ! header parameter
      character(len=80) strParticle     ! "FVPARTICLE"
      character(len=80) strVariable     ! variable name
      integer intVer(3)                 ! file format version

!!----
      integer nStep, nTotalPoint, nPointID
      real*4  SolutionTime, X, Y, Z, Scalar

!!----
      call ReadCtrlFile(                ! read control file
     &     FileInput, FileOutput)

!!----
      open(11, file=FileInput, access="direct", recl=4)
      open(21, file=FileOutput, status="unknown")

!!--------------------------------------! 
      nCount=1
      read(11, rec=nCount) intMAGIC
!      write(21, "(a2, i8)") "# ",intMAGIC
      write(21, "(X)") intMAGIC

      !!----- 
      do loop=1, 20
         nCount=nCount+1
         read(11, rec=nCount ) charTEMP
         write(strParticle(4*loop-3:4*loop),"(a4)") charTEMP
      end do
      write(21,"(a2, a80)") "# ",strParticle

      !!----- 
      do loop=1, 3
         nCount=nCount+1
         read(11, rec=nCount) intVer(loop)
      end do
      write(21, "('# Major Version:',i2,'.',i2,'  Minor Version:',i2)")
     &     (intVer(i), i=1, 3)


      !!----- 
      do loop=1, 20
         nCount=nCount+1
         read(11, rec=nCount ) charTEMP
         write(strVariable(4*loop-3:4*loop),"(a4)") charTEMP
      end do
      write(21,"(a2,a80)") "# ", strVariable

      do
         nCount=nCount+1
         read(11, rec=nCount, iostat=intEOF) nStep
         if(intEOF /= 0)then
            exit
         else
            write(21,"(a8,i10)")"# nStep:", nStep

            nCount=nCount+1
            read(11, rec=nCount) SolutionTime
            write(21, "(a15,f14.7)") "# SolutionTime:", SolutionTime
            nCount=nCount+1
            read(11, rec=nCount) nTotalPoint
            write(21, "(a15,i10)") "# Total Points:", nTotalPoint

            do loop=1, nTotalPoint
               nCount=nCount+1
               read(11, rec=nCount) nPointID
               ! write(21, *) "Point ID:", nPointID

               nCount=nCount+1
               read(11, rec=nCount) X
               nCount=nCount+1
               read(11, rec=nCount) Y
               nCount=nCount+1
               read(11, rec=nCount) Z
               nCount=nCount+1
               read(11, rec=nCount) Scalar

               write(21, "(4(1x,f10.4))") X, Y, Z, Scalar
            end do
            write(21, "(a)") ""
            write(21, "(a)") ""
         end if

      end do

      close(21)
      close(11)

      stop
      end program


!/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
      subroutine ReadCtrlFile(          ! read control file
     &     FileInput, FileOutput)

      character(len=*)  FileInput       ! input file
      character(len=*)  FileOutput      ! output file

!!---
      open(99, file="./Binary2ASCII_FVP.ctl", status="old")
      read(99,*)                        ! skip header
      read(99,"(a)") FileInput
      read(99,"(a)") FileOutput
      close(99)

!!---
      write(*,*) " "
      write(*,*) "---------------------------------------"
      write(*,*) "----------    Binary2ASCII_FVP.f    ---"
      write(*,*) "---------------------------------------"
      write(*,*) " "
      write(*,"(a10,a50)") " FileInput",FileInput
      write(*,"(a10,a50)") "FileOutput",FileOutput
      write(*,*) " "

      return
      end subroutine
