# coding: utf-8
# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2010 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *


print ("")
print ("-------------------------------------------------------")
print ("---------------- Python Sample PY116 ------------------")
print ("-------------------------------------------------------")
print ("")


## define data input table 
data_input_table  =  {
	'data_format' :   "unstructured",
	'input_parameters' :   {
			'name' :   './rect_duct_001.uns',
			'options' :   {
				'input_mode' :   "replace",
				#'transient' :   "on"
				'transient' :   "off"
		                  },
	                   }
                    }


## call function to read dataset
read_dataset(data_input_table)


## define coordinate surface table
coord_table = {
	'dataset' : 1,
	'scalar_func' : "temperature",
	'axis' : "Z",
	'Z_axis' : { 'current' : 0.0127},
	'display_type' : "smooth_shading",
	}

## create coordinate surface
create_coord(coord_table)


## save restart files
fv_script("SAVE ALL sample")

##---------------------------------------------------------------------
##   FAQ PY116 : file Input/Output
##---------------------------------------------------------------------


print ("")
print ("---------------------------")
print ("read file contents entirely")
print ("---------------------------")
print ("")
f = open('./sample.dat', 'r')
s = f.read()
print s
f.close()


print ("")
print ("---------------------------")
print ("read line contents sequentially")
print ("---------------------------")
print ("")
fp = open('./sample.vct', 'r')
s = fp.readline()
print s
s = fp.readline()
print s
fp.close()


print ("")
print ("---------------------------")
print ("detect End of File automatically")
print ("---------------------------")
print ("")
fp2 = open('./sample.map', 'r')
while 1:
	line = fp2.readline()
	if line == "" :                     # detect EOF
		break                           # break loop
	print line
fp2.close()


print ("")
print ("---------------------------")
print ("write to another file")
print ("---------------------------")
print ("")
fp1 = open('./sample.map', 'r')
fp2 = open('./output.map', 'w')
while 1:
	line = fp1.readline()
	if line == "" :                     # detect EOF
		break                           # break loop
	fp2.writelines(line)
fp2.close()
fp1.close()


