# coding: utf-8
# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2010 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *


print ("")
print ("-------------------------------------------------------")
print ("---------------- Python Sample PY115 ------------------")
print ("-------------------------------------------------------")
print ("")


## define data input table 
data_input_table  =  {
	'data_format' :   "unstructured",
	'input_parameters' :   {
			'name' :   './rect_duct_001.uns',
			'options' :   {
				'input_mode' :   "replace",
				'transient' :   "on"
		                  },
	                   }
                    }


## call function to read dataset
read_dataset(data_input_table)


## define coordinate surface table
coord_table = {
	'dataset' : 1,
	'scalar_func' : "temperature",
	'axis' : "Z",
	'Z_axis' : { 'current' : 0.0127},
	'display_type' : "smooth_shading",
	}

## create coordinate surface
create_coord(coord_table)


## save restart files
fv_script("SAVE ALL sample")

##---------------------------------------------------------------------
##   FAQ PY115 : Transient Pointprobe 
##---------------------------------------------------------------------

print ("")

## define target point
ppoint = {
	1: 0.0596924,
	2: 0.0263684,
	3: 0.0254}

## obtain transient query information
transient_info = query_transient()
TotalTimeSteps=transient_info.get("total_time_steps")
time_step_range = transient_info.get("time_step_range")
time_val = time_step_range.get("values")

print ("---- start loop process ----")

for i in range(1, TotalTimeSteps+1, 1) :

	print ("-------------------")
	strLoopCheck="Transient Loop Number: %7.5f th\n " % i
	print strLoopCheck,

	SampleTable = {
		'time_step' : time_val[i]
	}

	set_transient(SampleTable)

	SampleTable2=query_transient()
	tmp=SampleTable2.get("solution_time")
	strCurSolTime="Current Solution Time : %7.5f [sec]\n " % tmp
	print strCurSolTime,

	# -- extract pointprobe value
	probeout = probe_current_functions(ppoint,1)
	pScalar = probeout.get("scalar")
	pval = pScalar.get("value")

	strPointProbe="PointProbe Value : %7.5f [degC]\n " % pval
	print strPointProbe,

#end




