# coding: utf-8
# -----------------------------------------------------------------------
# --
# -- Copyright (c) 2010 VINAS
# -- All rights reserved.
# --
# -- This sample FieldView Python script is not supported
# --                                     by VINAS and VINAS provides
# -- no warranties or assurances about its fitness or merchantability.
# -- It is provided at no cost and is for demonstration purposes only.
# --
# -----------------------------------------------------------------------

import sys
print("Python version is ", sys.version)

from fv import *


print ("")
print ("-------------------------------------------------------")
print ("---------------- Python Sample PY114 ------------------")
print ("-------------------------------------------------------")
print ("")


## define data input table 
data_input_table  =  {
	'data_format' :   "unstructured",
	'input_parameters' :   {
			'name' :   './rect_duct_001.uns',
			'options' :   {
				'input_mode' :   "replace",
				'transient' :   "on"
		                  },
	                   }
                    }


## call function to read dataset
read_dataset(data_input_table)


## define coordinate surface table
coord_table = {
	'dataset' : 1,
	'scalar_func' : "temperature",
	'axis' : "Z",
	'Z_axis' : { 'current' : 0.0127},
	'display_type' : "smooth_shading",
	}



## create coordinate surface
create_coord(coord_table)


## save restart files
fv_script("SAVE ALL sample")

##---------------------------------------------------------------------

## obtain transient query information
transient_info = query_transient()

## list up dictionary elements in "transient_info"
print(" ----- key list -----")
for key in transient_info.keys():
	print (key)
print("")

## list up dictionary elements' values
print(" ----- value list -----")
for value in transient_info.values():
	print (value)
print("")

## list up dictionary key and elements' values
print(" ----- item list -----")
for key, value in transient_info.items():
	print (key,  ":",  value)
print("")


## use each parameter
CurrentTimeStep=transient_info.get("time_step")
print("Current Time Step : ", CurrentTimeStep)

TotalTimeSteps=transient_info.get("total_time_steps")
print(" Total Time Steps : ", TotalTimeSteps)

CurrentSolutionTime=transient_info.get("solution_time")
strCST="Current Solution Time : %7.5f" % CurrentSolutionTime
print(strCST)

SolutionTimeRange=transient_info.get("solution_time_range")
SolutionTimeMin=SolutionTimeRange.get("min")
strSTM="Solution Time Min: %7.5f" % SolutionTimeMin
print(strSTM)

SolutionTimeRange=transient_info.get("solution_time_range")
SolutionTimeMax=SolutionTimeRange.get("max")
strSTM="Solution Time Max: %7.5f" % SolutionTimeMax
print(strSTM)




##---------------------------------------------------------------------
##   FAQ PY114 : Transient Loop procedure
##---------------------------------------------------------------------

print ("")
print ("---- PY114 original procedure ----")

time_step_range = transient_info.get("time_step_range")
time_val = time_step_range.get("values")


for i in range(1, TotalTimeSteps+1, 1) :

	print ("-------------------")
	strLoopCheck="Transient Loop Number: %7.5f th\n " % i
	print strLoopCheck,

	SampleTable = {
		'time_step' : time_val[i]
	}

	set_transient(SampleTable)

	SampleTable2=query_transient()
	tmp=SampleTable2.get("solution_time")
	strCurSolTime="Current Solution Time : %7.5f [sec]\n " % tmp
	print strCurSolTime,


#end




