//-----------------------------------------------------------------------
//--
//-- Copyright (c) 2010 VINAS
//-- All rights reserved.
//--
//-- This sample C programme is not supported by VINAS and VINAS provides
//-- no warranties or assurances about its fitness or merchantability.
//-- It is provided at no cost and is for demonstration purposes only.
//--
//--
//--                                          Binary2ASCII_FVP.C
//--
//--                                        T.Y.   Mon. August 23, 2010 
//--
//----------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAJOR_VERSION 1.1
#define MINOR_VERSION 1
#define FV_MAGIC 0x00010203

//----------------------------------------------------------------------
//*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
int main(void)
{

	FILE *fp, *fpi, *fpo;
//	char *fname = "./output.fvp";
	char *ctrlFile = "./Binary2ASCII_FVP.ctl";

	unsigned char buf[80];
	int  i, j, k, size;

	char str[256];
	char FileInput[256];				// input file name
	char FileOutput[256];				// output file name

	int magic_num;						// MAGIC NUMBER '010203'
	unsigned char strParticle[80];		// 'FVPARTICLES'
	int major_version;					// major version
	int minor_version;					// minor version
	int numVariables;					// number of variables
	int TimeStep;						// time step
	float SolutionTime;					// solution time
	int numParticles;					// number of particles
	int PathID;							// Path ID
	float x, y, z;						// particle position
	float value;						// value of each variable

//--------------------------------------


	fp = fopen( ctrlFile, "r" );
	if( fp == NULL ){
		printf( "Cannot Open File %s\n", ctrlFile);
		return (-1);
	}


	printf( "------------------------------------------\n");
	printf( "----------  Binary2ASCII_FVP.C  ----------\n");
	printf( "------------------------------------------\n");
	printf( "\n");

	fgets(str, sizeof( str ), fp);
	strcpy(FileInput, "");
	fscanf(fp, "%s", FileInput);
	printf( " FileInput : %s\n" , FileInput );
	fscanf(fp, "%s", FileOutput);
	printf( "FileOutput : %s\n" , FileOutput );

	fclose( fp );

//----------------------------------------------------------------------
	// printf("%s\n", FileInput);
	fpi = fopen( FileInput, "rb" );
	if( fpi == NULL ){
		printf( "%st@CJ܂\n", FileInput);
		return (-1);
	}

	// printf("%s\n", FileOutput);
	fpo = fopen( FileOutput, "w" );
	if( fpo == NULL ){
		printf( "%st@CJ܂\n", FileOutput);
		return (-1);
	}

//--------------------------------------

	// magic number parts
	fread( &magic_num, sizeof( int ), 1, fpi);
	// fprintf(fpo, "# magic number : %10x\n", magic_num );

	// 'FVPARTICLES' STRING
	fread( &strParticle, sizeof( unsigned char ), 80, fpi);
	fprintf(fpo, "\n");
	fprintf(fpo, "# FVPARTICLES : %s\n", strParticle );

	// major/ minor version
	fread( &major_version, sizeof( int ), 1, fpi);
	fprintf(fpo, "# major version : %5d / ", major_version );
	fread( &minor_version, sizeof( int ), 1, fpi);
	fprintf(fpo, " minor version : %5d\n", minor_version );

	// number of varialbes other than solution time
	fread( &numVariables, sizeof( int ), 1, fpi);
	// fprintf(fpo, "# Number of Variables \n");
	// fprintf(fpo, "#  other than solution time : %5d\n", numVariables );

	// each variable name string
	for (k=0; k < numVariables; k++){
		fread( &buf, sizeof( unsigned char ), 80, fpi);
		fprintf(fpo, "# variable name [%d] : %s\n", k, buf );
	}


//--------------------------------------
	while ((size=fread( &TimeStep, sizeof( int ), 1, fpi)) > 0){
		fprintf(fpo, "#     Time Step : %5d\n", TimeStep );
		fread( &SolutionTime, sizeof( float ), 1, fpi);
		fprintf(fpo, "# SolutionTime  : %14.7f\n", SolutionTime );
		fread( &numParticles, sizeof( int ), 1, fpi);
		fprintf(fpo, "#  particle num : %5d\n", numParticles );

		for (i=0; i < numParticles; i++){
			fread( &PathID, sizeof( int ), 1, fpi);
			//printf( "#      Path ID : %5d\n", PathID );
			fread( &x, sizeof( float ), 1, fpi);
			fread( &y, sizeof( float ), 1, fpi);
			fread( &z, sizeof( float ), 1, fpi);
			// fprintf(fpo, "pos. of x y z : %10.4f %10.4f %10.4f", x, y, z );
			fprintf(fpo, " %10.4f %10.4f %10.4f", x, y, z );

			for (j=0; j < numVariables; j++){
				fread( &value, sizeof( float ), 1, fpi);
				fprintf(fpo, "  %10.4f", value );
				//printf( "value  : %10.4f\n", value );
			}
			fprintf(fpo, "\n");
		}
		fprintf(fpo, "\n\n");
	}
//--------------------------------------


	fclose( fpo );
	fclose( fpi );
	return (0);
}

